// PCIEDIOM.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "stdio.h"
#include "stdlib.h"
#include "conio.h"
#include "PciTg2.h"

void CMD()
{
	system("cls");
	printf("[ Press Command ]\n");
	printf("***********************************\n");
	printf("1 : Set IO Port-1 to output mode\n");
	printf("2 : IO Port-1 1PA Output [0x55]\n");
	printf("3 : IO Port-1 1PB Output [0xAA]\n");
	printf("4 : IO Port-1 1PC Output [0x55]\n");
	printf("***********************************\n");
	printf("5 : Set IO Port-1 to input mode\n");
	printf("6 : IO Port-1 1PA Input \n");
	printf("7 : IO Port-1 1PB Input \n");
	printf("8 : IO Port-1 1PC Input \n");
	printf("***********************************\n");
	printf("a : Set IO Port-2 to output mode\n");
	printf("b : IO Port-2 1PA Output [0x55]\n");
	printf("c : IO Port-2 1PB Output [0xAA]\n");
	printf("d : IO Port-2 1PC Output [0x55]\n");
	printf("***********************************\n");
	printf("e : Set IO Port-2 to input mode\n");
	printf("f : IO Port-2 1PA Input \n");
	printf("g : IO Port-2 1PB Input \n");
	printf("h : IO Port-2 1PC Input \n");
	printf("***********************************\n");
	printf("i : Get DIP SW ID \n");
	printf("q : Quit\n\n");
	printf("Function : ");
}

int main(int argc, char* argv[])
{
	int status = 0;
    char ch;
	int rdata = 0;
	int dipswid = 0;
	int validswid[4];
	int boardid = 0;
	
	status = PciTg2_open2();
	if (status != 0)
	{
		printf("Can't open PCIE DIO device\n");
		PciTg2_close();
		return 0;
	}
    
	//To check valid PCIEDIO card ID by [S1] DIP switch setting 
	PciTg2_getvalidid2(validswid);
	for(int i=0; i< 4;i++)
	{
	   if (validswid[i] == 1) 
		   boardid = i;
	}
	
    //Set 1PA/1PB/1PC output mode, 2PA/2PB/2PC input mode
    PciTg2_out2(boardid, 0x6, 0x70);
    CMD();

	do
	{
		ch = getch();
		switch(ch)
		{
		case '1' :
				  CMD();
				  //[IO]- control offset: 0x06
				  //Read IO control register data
				  rdata = PciTg2_in2(boardid, 0x6);
				  rdata &=0x70;

				  //Set 1PA/1PB/1PC to output mode
				  PciTg2_out2(boardid, 0x6, rdata);
				  printf("Command [1]\n");
				  printf("[Port-1] (J6) IO control mode : [ output ]\n");
			break;
		case '2' :
			      //1PA control offset : 0x0 
			      CMD(); 
				  PciTg2_out2(boardid, 0x0, 0x55);
				  printf("Command [2]\n");
				  printf("[Port-1] 1PA output data : [0x55]\n");
			break;
		case '3':
			      //1PB control offset : 0x01 
			      CMD(); 
				  PciTg2_out2(boardid, 0x01, 0xAA);
				  printf("Command [3]\n");
				  printf("[Port-1] 1PB output data : [0xAA]\n");

			break;
		case '4':
			      //1PC control offset : 0x02 
				  CMD(); 
				  PciTg2_out2(boardid, 0x02, 0x55);
				  printf("Command [4]\n");
				  printf("[Port-1] 1PC output data : [0x55]\n");
			break;
		case '5':
			     CMD(); 
				 //[IO] control offset: 0x06
				 //Read IO control register data
				 rdata = PciTg2_in2(boardid, 0x6);
				 rdata |=0x07;
    
				 //Set 1PA/1PB/1PC to input mode
				 PciTg2_out2(boardid, 0x6, rdata);
				 printf("Command [5]\n");
				 printf("[Port-1] (J6) IO control mode : [ input ]\n");
			break;
		case '6':
			     //1PA control offset : 0x0 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x0);
				 printf("Command [6]\n");
				 printf("[Port-1] 1PA input data : 0x%X",rdata);
			break;
		case '7':
			     //1PB control offset : 0x01 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x01);
				 printf("Command [7]\n");
				 printf("[Port-1] 1PB input data : 0x%X",rdata);
			break;
		case '8':
				 //1PC control offset : 0x02 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x02);
				 printf("Command [8]\n");
				 printf("[Port-1] 1PC input data : 0x%X",rdata);
			break;
		case 'a':
			     CMD();
				 //[IO]- control offset: 0x06
				 //Read IO control register data
				 rdata = PciTg2_in2(boardid, 0x6);
				 rdata &=0x07;

				 //Set 2PA/2PB/2PC to output mode
				 PciTg2_out2(boardid, 0x6, rdata);
				 printf("Command [a]\n");
				 printf("[Port-2] (J8) IO control mode : [ output ]\n");
			break;
		case 'b':
			     //2PA control offset : 0x03 
			     CMD(); 
				 PciTg2_out2(boardid, 0x03, 0x55);
				 printf("Command [b]\n");
				 printf("[Port-2] 2PA output data : [0x55]\n");
			break;
		case 'c':
			     //2PB control offset : 0x04 
			     CMD(); 
				 PciTg2_out2(boardid, 0x04, 0xAA);
				 printf("Command [c]\n");
				 printf("[Port-2] 2PB output data : [0xAA]\n");
			break;
		case 'd':
				 //2PC control offset : 0x05 
			     CMD(); 
				 PciTg2_out2(boardid, 0x05, 0x55);
				 printf("Command [d]\n");
				 printf("[Port-2] 2PC output data : [0x55]\n");

			break;
		case 'e':
			     CMD(); 
				 //[IO] control offset: 0x06
				 //Read IO control register data
				 rdata = PciTg2_in2(boardid, 0x6);
				 rdata |=0x70;
    
				 //Set 2PA/2PB/2PC to input mode
				 PciTg2_out2(boardid, 0x6, rdata);
				 printf("Command [e]\n");
				 printf("[Port-2] (J8) IO control mode : [ input ]\n");
			break;
		case 'f':
                 //2PA control offset : 0x03 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x03);
				 printf("Command [f]\n");
				 printf("[Port-2] 2PA input data : 0x%X",rdata);
			break;
		case 'g':
			     //2PB control offset : 0x04 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x04);
				 printf("Command [g]\n");
				 printf("[Port-2] 2PB input data : 0x%X",rdata);
			break;
		case 'h':
			     //2PC control offset : 0x05 
			     CMD();
			     rdata = PciTg2_in2(boardid, 0x05);
				 printf("Command [h]\n");
				 printf("[Port-2] 2PC input data : 0x%X",rdata);
			break;
		case 'i':
				 CMD();
			     rdata = PciTg2_in2(boardid, 0x6);
	             //Get DIP switch ID1 value
	             if(rdata & 0x80)
                 dipswid |=0x02;

	             //Get DIP switch ID2 value
	             if(rdata & 0x08)
		         dipswid |=0x01;
				 printf("Command [i]\n");
                 printf("Get PCIE DIO card ID : [ %d ]",dipswid);
			break;
		default:
			break;
		}

	}while(ch != 'q');
    CMD();
    PciTg2_close2();
	printf("Command [q]\n");
	printf("Quit\n");

	return 0;
}